/*****************************************************************\
*                                                                *
*  Copyright (C) Regents of University of California, 2003       *
*  This source code is a part of EXPRESSION project and is       *
*  copyrighted by the Regents of the University of California,   *
*  Irvine.                                                       *
*  The authors hereby grant permission to use this description   *
*  and its documentation for educational and non-commercial      *
*  purpose under the BSD license                                 *
*  (http://www.cecs.uci.edu/~express/BSD_License.txt). 	         *
*  The source code comes with no warranty and no author or       *
*  distributor accepts any responsibility for the consequences   *
*  of its use. Permission is granted to distribute this file in  *
*  compiled or executable form under the same conditions that    *
*  apply for source code. Permission is granted	to anyone to     *
*  make or distribute copies of this source code, either as      *
*  received or modified, in any medium, provided that all        *
*  copyright notices, permission and non warranty notices are    *
*  preserved, and that the distributor grants the recipient      *
*  permission for further redistribution as permitted by this    *
*  document. No written agreement, license, or royalty fee is    *
*  required for authorized use of this software.                 *
*                                                                *
*******************************************************************/
/********************************************/
/* file: symtabs.h							*/
/* created: Nov. 30, 1998					*/
/* authors: pgrun							*/
/* last modified:							*/
/* contents: symtab defintions				*/
/********************************************/
#ifndef _SYMTABS_H_
#define _SYMTABS_H_

#include "node.h"

class Symtab {
    SymbolList _symlist; 
public:
    Symtab(void){}
	SymbolPtr Declare(char *name,NodePtr node); 
    SymbolPtr FindSymbol(char * name); //returns NULL if it doesn't find it
	SymbolPtr GetSymbol(char * name); //Gives error if it doesn't find it
	int Traverse(int(* func)(SymbolPtr));
	void UpdateSymbols(NodeListPtr list);
	void FixRegDefs();
	void Print();
	void patchForwRefs();
};

#endif

